Scriptname _SLSubmitIndecencyEffect extends ActiveMagicEffect  

_SLSubmitConfig Property _SLConfig auto
_SLSubmitScene Property _SLScene auto

Spell Property _SLSubmitIndecency  Auto  
Faction Property CrimeFactionOrcs Auto
SexLabFramework Property SexLab  Auto  
Actor Property PlayerRef Auto
GlobalVariable Property IndecencyGlobal Auto

Event OnEffectStart(actor Target, actor Caster)
	sslThreadController Thread = SexLab.GetPlayerController()
	If Thread != None && Thread.GetState() == "Animating" && (_SLConfig.GuardActive) && (Target.IsGuard() && Target.HasLOS(PlayerRef) && !Target.IsInFaction(CrimeFactionOrcs))
		debug.Notification(Target.GetBaseObject().GetName() + " saw you!")
		IndecencyGlobal.SetValue(1)
		_SLScene.WRT(0.1)
		Thread.EndAnimation(True)
		Target.SendTrespassAlarm(PlayerRef)
		If (Caster.HasSpell(_SLSubmitIndecency))
			Caster.RemoveSpell(_SLSubmitIndecency)
		EndIf
	EndIf
EndEvent